package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSipRuleRequest(sipRuleId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteSipRuleRequest = {
    import DeleteSipRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteSipRuleRequest
      .builder()
      .sipRuleId(NonEmptyString.unwrap(sipRuleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeleteSipRuleRequest.ReadOnly =
    zio.aws.chime.model.DeleteSipRuleRequest.wrap(buildAwsValue())
}
object DeleteSipRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteSipRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteSipRuleRequest =
      zio.aws.chime.model.DeleteSipRuleRequest(sipRuleId)
    def sipRuleId: NonEmptyString
    def getSipRuleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(sipRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteSipRuleRequest
  ) extends zio.aws.chime.model.DeleteSipRuleRequest.ReadOnly {
    override val sipRuleId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.sipRuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteSipRuleRequest
  ): zio.aws.chime.model.DeleteSipRuleRequest.ReadOnly = new Wrapper(impl)
}
