package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorEmergencyCallingConfigurationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest = {
    import DeleteVoiceConnectorEmergencyCallingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly =
    zio.aws.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorEmergencyCallingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest =
      zio.aws.chime.model
        .DeleteVoiceConnectorEmergencyCallingConfigurationRequest(
          voiceConnectorId
        )
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
  ) extends zio.aws.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
  ): zio.aws.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
