package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorGroupRequest(
    voiceConnectorGroupId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorGroupRequest = {
    import DeleteVoiceConnectorGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorGroupRequest
      .builder()
      .voiceConnectorGroupId(
        NonEmptyString.unwrap(voiceConnectorGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DeleteVoiceConnectorGroupRequest.ReadOnly =
    zio.aws.chime.model.DeleteVoiceConnectorGroupRequest.wrap(buildAwsValue())
}
object DeleteVoiceConnectorGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteVoiceConnectorGroupRequest =
      zio.aws.chime.model
        .DeleteVoiceConnectorGroupRequest(voiceConnectorGroupId)
    def voiceConnectorGroupId: NonEmptyString
    def getVoiceConnectorGroupId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorGroupRequest
  ) extends zio.aws.chime.model.DeleteVoiceConnectorGroupRequest.ReadOnly {
    override val voiceConnectorGroupId: NonEmptyString =
      zio.aws.chime.model.primitives
        .NonEmptyString(impl.voiceConnectorGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorGroupRequest
  ): zio.aws.chime.model.DeleteVoiceConnectorGroupRequest.ReadOnly =
    new Wrapper(impl)
}
