package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorOriginationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorOriginationRequest = {
    import DeleteVoiceConnectorOriginationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorOriginationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DeleteVoiceConnectorOriginationRequest.ReadOnly =
    zio.aws.chime.model.DeleteVoiceConnectorOriginationRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorOriginationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorOriginationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteVoiceConnectorOriginationRequest =
      zio.aws.chime.model
        .DeleteVoiceConnectorOriginationRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorOriginationRequest
  ) extends zio.aws.chime.model.DeleteVoiceConnectorOriginationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorOriginationRequest
  ): zio.aws.chime.model.DeleteVoiceConnectorOriginationRequest.ReadOnly =
    new Wrapper(impl)
}
