package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString128
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorProxyRequest(
    voiceConnectorId: NonEmptyString128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorProxyRequest = {
    import DeleteVoiceConnectorProxyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorProxyRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DeleteVoiceConnectorProxyRequest.ReadOnly =
    zio.aws.chime.model.DeleteVoiceConnectorProxyRequest.wrap(buildAwsValue())
}
object DeleteVoiceConnectorProxyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorProxyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteVoiceConnectorProxyRequest =
      zio.aws.chime.model.DeleteVoiceConnectorProxyRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString128
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorProxyRequest
  ) extends zio.aws.chime.model.DeleteVoiceConnectorProxyRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chime.model.primitives.NonEmptyString128(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorProxyRequest
  ): zio.aws.chime.model.DeleteVoiceConnectorProxyRequest.ReadOnly =
    new Wrapper(impl)
}
