package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorStreamingConfigurationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest = {
    import DeleteVoiceConnectorStreamingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest.ReadOnly =
    zio.aws.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorStreamingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest =
      zio.aws.chime.model
        .DeleteVoiceConnectorStreamingConfigurationRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest
  ) extends zio.aws.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest
  ): zio.aws.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
