package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorTerminationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationRequest = {
    import DeleteVoiceConnectorTerminationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DeleteVoiceConnectorTerminationRequest.ReadOnly =
    zio.aws.chime.model.DeleteVoiceConnectorTerminationRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorTerminationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteVoiceConnectorTerminationRequest =
      zio.aws.chime.model
        .DeleteVoiceConnectorTerminationRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationRequest
  ) extends zio.aws.chime.model.DeleteVoiceConnectorTerminationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteVoiceConnectorTerminationRequest
  ): zio.aws.chime.model.DeleteVoiceConnectorTerminationRequest.ReadOnly =
    new Wrapper(impl)
}
