package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAppInstanceAdminResponse(
    appInstanceAdmin: Optional[zio.aws.chime.model.AppInstanceAdmin] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeAppInstanceAdminResponse = {
    import DescribeAppInstanceAdminResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeAppInstanceAdminResponse
      .builder()
      .optionallyWith(appInstanceAdmin.map(value => value.buildAwsValue()))(
        _.appInstanceAdmin
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DescribeAppInstanceAdminResponse.ReadOnly =
    zio.aws.chime.model.DescribeAppInstanceAdminResponse.wrap(buildAwsValue())
}
object DescribeAppInstanceAdminResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeAppInstanceAdminResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DescribeAppInstanceAdminResponse =
      zio.aws.chime.model.DescribeAppInstanceAdminResponse(
        appInstanceAdmin.map(value => value.asEditable)
      )
    def appInstanceAdmin
        : Optional[zio.aws.chime.model.AppInstanceAdmin.ReadOnly]
    def getAppInstanceAdmin
        : ZIO[Any, AwsError, zio.aws.chime.model.AppInstanceAdmin.ReadOnly] =
      AwsError.unwrapOptionField("appInstanceAdmin", appInstanceAdmin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeAppInstanceAdminResponse
  ) extends zio.aws.chime.model.DescribeAppInstanceAdminResponse.ReadOnly {
    override val appInstanceAdmin
        : Optional[zio.aws.chime.model.AppInstanceAdmin.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appInstanceAdmin())
        .map(value => zio.aws.chime.model.AppInstanceAdmin.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeAppInstanceAdminResponse
  ): zio.aws.chime.model.DescribeAppInstanceAdminResponse.ReadOnly =
    new Wrapper(impl)
}
