package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAppInstanceRequest(appInstanceArn: ChimeArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeAppInstanceRequest = {
    import DescribeAppInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeAppInstanceRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DescribeAppInstanceRequest.ReadOnly =
    zio.aws.chime.model.DescribeAppInstanceRequest.wrap(buildAwsValue())
}
object DescribeAppInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeAppInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DescribeAppInstanceRequest =
      zio.aws.chime.model.DescribeAppInstanceRequest(appInstanceArn)
    def appInstanceArn: ChimeArn
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeAppInstanceRequest
  ) extends zio.aws.chime.model.DescribeAppInstanceRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeAppInstanceRequest
  ): zio.aws.chime.model.DescribeAppInstanceRequest.ReadOnly = new Wrapper(impl)
}
