package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAppInstanceResponse(
    appInstance: Optional[zio.aws.chime.model.AppInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeAppInstanceResponse = {
    import DescribeAppInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeAppInstanceResponse
      .builder()
      .optionallyWith(appInstance.map(value => value.buildAwsValue()))(
        _.appInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DescribeAppInstanceResponse.ReadOnly =
    zio.aws.chime.model.DescribeAppInstanceResponse.wrap(buildAwsValue())
}
object DescribeAppInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeAppInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DescribeAppInstanceResponse =
      zio.aws.chime.model
        .DescribeAppInstanceResponse(appInstance.map(value => value.asEditable))
    def appInstance: Optional[zio.aws.chime.model.AppInstance.ReadOnly]
    def getAppInstance
        : ZIO[Any, AwsError, zio.aws.chime.model.AppInstance.ReadOnly] =
      AwsError.unwrapOptionField("appInstance", appInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeAppInstanceResponse
  ) extends zio.aws.chime.model.DescribeAppInstanceResponse.ReadOnly {
    override val appInstance
        : Optional[zio.aws.chime.model.AppInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appInstance())
        .map(value => zio.aws.chime.model.AppInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeAppInstanceResponse
  ): zio.aws.chime.model.DescribeAppInstanceResponse.ReadOnly = new Wrapper(
    impl
  )
}
