package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAppInstanceUserRequest(appInstanceUserArn: ChimeArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserRequest = {
    import DescribeAppInstanceUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserRequest
      .builder()
      .appInstanceUserArn(ChimeArn.unwrap(appInstanceUserArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DescribeAppInstanceUserRequest.ReadOnly =
    zio.aws.chime.model.DescribeAppInstanceUserRequest.wrap(buildAwsValue())
}
object DescribeAppInstanceUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DescribeAppInstanceUserRequest =
      zio.aws.chime.model.DescribeAppInstanceUserRequest(appInstanceUserArn)
    def appInstanceUserArn: ChimeArn
    def getAppInstanceUserArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceUserArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserRequest
  ) extends zio.aws.chime.model.DescribeAppInstanceUserRequest.ReadOnly {
    override val appInstanceUserArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceUserArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserRequest
  ): zio.aws.chime.model.DescribeAppInstanceUserRequest.ReadOnly = new Wrapper(
    impl
  )
}
