package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAppInstanceUserResponse(
    appInstanceUser: Optional[zio.aws.chime.model.AppInstanceUser] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserResponse = {
    import DescribeAppInstanceUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserResponse
      .builder()
      .optionallyWith(appInstanceUser.map(value => value.buildAwsValue()))(
        _.appInstanceUser
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DescribeAppInstanceUserResponse.ReadOnly =
    zio.aws.chime.model.DescribeAppInstanceUserResponse.wrap(buildAwsValue())
}
object DescribeAppInstanceUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DescribeAppInstanceUserResponse =
      zio.aws.chime.model.DescribeAppInstanceUserResponse(
        appInstanceUser.map(value => value.asEditable)
      )
    def appInstanceUser: Optional[zio.aws.chime.model.AppInstanceUser.ReadOnly]
    def getAppInstanceUser
        : ZIO[Any, AwsError, zio.aws.chime.model.AppInstanceUser.ReadOnly] =
      AwsError.unwrapOptionField("appInstanceUser", appInstanceUser)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserResponse
  ) extends zio.aws.chime.model.DescribeAppInstanceUserResponse.ReadOnly {
    override val appInstanceUser
        : Optional[zio.aws.chime.model.AppInstanceUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appInstanceUser())
        .map(value => zio.aws.chime.model.AppInstanceUser.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeAppInstanceUserResponse
  ): zio.aws.chime.model.DescribeAppInstanceUserResponse.ReadOnly = new Wrapper(
    impl
  )
}
