package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelBanResponse(
    channelBan: Optional[zio.aws.chime.model.ChannelBan] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeChannelBanResponse = {
    import DescribeChannelBanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeChannelBanResponse
      .builder()
      .optionallyWith(channelBan.map(value => value.buildAwsValue()))(
        _.channelBan
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DescribeChannelBanResponse.ReadOnly =
    zio.aws.chime.model.DescribeChannelBanResponse.wrap(buildAwsValue())
}
object DescribeChannelBanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeChannelBanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DescribeChannelBanResponse =
      zio.aws.chime.model
        .DescribeChannelBanResponse(channelBan.map(value => value.asEditable))
    def channelBan: Optional[zio.aws.chime.model.ChannelBan.ReadOnly]
    def getChannelBan
        : ZIO[Any, AwsError, zio.aws.chime.model.ChannelBan.ReadOnly] =
      AwsError.unwrapOptionField("channelBan", channelBan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelBanResponse
  ) extends zio.aws.chime.model.DescribeChannelBanResponse.ReadOnly {
    override val channelBan: Optional[zio.aws.chime.model.ChannelBan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelBan())
        .map(value => zio.aws.chime.model.ChannelBan.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelBanResponse
  ): zio.aws.chime.model.DescribeChannelBanResponse.ReadOnly = new Wrapper(impl)
}
