package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelMembershipForAppInstanceUserRequest(
    channelArn: ChimeArn,
    appInstanceUserArn: ChimeArn,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserRequest = {
    import DescribeChannelMembershipForAppInstanceUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .appInstanceUserArn(ChimeArn.unwrap(appInstanceUserArn): java.lang.String)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserRequest.ReadOnly =
    zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserRequest
      .wrap(buildAwsValue())
}
object DescribeChannelMembershipForAppInstanceUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserRequest =
      zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserRequest(
        channelArn,
        appInstanceUserArn,
        chimeBearer.map(value => value)
      )
    def channelArn: ChimeArn
    def appInstanceUserArn: ChimeArn
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getAppInstanceUserArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceUserArn)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserRequest
  ) extends zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val appInstanceUserArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceUserArn())
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserRequest
  ): zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserRequest.ReadOnly =
    new Wrapper(impl)
}
