package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelMembershipForAppInstanceUserResponse(
    channelMembership: Optional[
      zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserResponse = {
    import DescribeChannelMembershipForAppInstanceUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserResponse
      .builder()
      .optionallyWith(channelMembership.map(value => value.buildAwsValue()))(
        _.channelMembership
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly =
    zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse
      .wrap(buildAwsValue())
}
object DescribeChannelMembershipForAppInstanceUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse =
      zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse(
        channelMembership.map(value => value.asEditable)
      )
    def channelMembership: Optional[
      zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ]
    def getChannelMembership: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ] = AwsError.unwrapOptionField("channelMembership", channelMembership)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserResponse
  ) extends zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly {
    override val channelMembership: Optional[
      zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.channelMembership())
      .map(value =>
        zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelMembershipForAppInstanceUserResponse
  ): zio.aws.chime.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly =
    new Wrapper(impl)
}
