package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelMembershipResponse(
    channelMembership: Optional[zio.aws.chime.model.ChannelMembership] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeChannelMembershipResponse = {
    import DescribeChannelMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeChannelMembershipResponse
      .builder()
      .optionallyWith(channelMembership.map(value => value.buildAwsValue()))(
        _.channelMembership
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DescribeChannelMembershipResponse.ReadOnly =
    zio.aws.chime.model.DescribeChannelMembershipResponse.wrap(buildAwsValue())
}
object DescribeChannelMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeChannelMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DescribeChannelMembershipResponse =
      zio.aws.chime.model.DescribeChannelMembershipResponse(
        channelMembership.map(value => value.asEditable)
      )
    def channelMembership
        : Optional[zio.aws.chime.model.ChannelMembership.ReadOnly]
    def getChannelMembership
        : ZIO[Any, AwsError, zio.aws.chime.model.ChannelMembership.ReadOnly] =
      AwsError.unwrapOptionField("channelMembership", channelMembership)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelMembershipResponse
  ) extends zio.aws.chime.model.DescribeChannelMembershipResponse.ReadOnly {
    override val channelMembership
        : Optional[zio.aws.chime.model.ChannelMembership.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelMembership())
        .map(value => zio.aws.chime.model.ChannelMembership.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelMembershipResponse
  ): zio.aws.chime.model.DescribeChannelMembershipResponse.ReadOnly =
    new Wrapper(impl)
}
