package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelModeratedByAppInstanceUserRequest(
    channelArn: ChimeArn,
    appInstanceUserArn: ChimeArn,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserRequest = {
    import DescribeChannelModeratedByAppInstanceUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .appInstanceUserArn(ChimeArn.unwrap(appInstanceUserArn): java.lang.String)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserRequest.ReadOnly =
    zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserRequest
      .wrap(buildAwsValue())
}
object DescribeChannelModeratedByAppInstanceUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserRequest =
      zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserRequest(
        channelArn,
        appInstanceUserArn,
        chimeBearer.map(value => value)
      )
    def channelArn: ChimeArn
    def appInstanceUserArn: ChimeArn
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getAppInstanceUserArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceUserArn)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserRequest
  ) extends zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val appInstanceUserArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceUserArn())
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserRequest
  ): zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserRequest.ReadOnly =
    new Wrapper(impl)
}
