package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelModeratedByAppInstanceUserResponse(
    channel: Optional[
      zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserResponse = {
    import DescribeChannelModeratedByAppInstanceUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserResponse
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly =
    zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse
      .wrap(buildAwsValue())
}
object DescribeChannelModeratedByAppInstanceUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse =
      zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse(
        channel.map(value => value.asEditable)
      )
    def channel: Optional[
      zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ]
    def getChannel: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ] = AwsError.unwrapOptionField("channel", channel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserResponse
  ) extends zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly {
    override val channel: Optional[
      zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.channel())
      .map(value =>
        zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelModeratedByAppInstanceUserResponse
  ): zio.aws.chime.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly =
    new Wrapper(impl)
}
