package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelModeratorRequest(
    channelArn: ChimeArn,
    channelModeratorArn: ChimeArn,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeChannelModeratorRequest = {
    import DescribeChannelModeratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeChannelModeratorRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .channelModeratorArn(
        ChimeArn.unwrap(channelModeratorArn): java.lang.String
      )
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DescribeChannelModeratorRequest.ReadOnly =
    zio.aws.chime.model.DescribeChannelModeratorRequest.wrap(buildAwsValue())
}
object DescribeChannelModeratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeChannelModeratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DescribeChannelModeratorRequest =
      zio.aws.chime.model.DescribeChannelModeratorRequest(
        channelArn,
        channelModeratorArn,
        chimeBearer.map(value => value)
      )
    def channelArn: ChimeArn
    def channelModeratorArn: ChimeArn
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getChannelModeratorArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(channelModeratorArn)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelModeratorRequest
  ) extends zio.aws.chime.model.DescribeChannelModeratorRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val channelModeratorArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelModeratorArn())
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelModeratorRequest
  ): zio.aws.chime.model.DescribeChannelModeratorRequest.ReadOnly = new Wrapper(
    impl
  )
}
