package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelModeratorResponse(
    channelModerator: Optional[zio.aws.chime.model.ChannelModerator] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeChannelModeratorResponse = {
    import DescribeChannelModeratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeChannelModeratorResponse
      .builder()
      .optionallyWith(channelModerator.map(value => value.buildAwsValue()))(
        _.channelModerator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DescribeChannelModeratorResponse.ReadOnly =
    zio.aws.chime.model.DescribeChannelModeratorResponse.wrap(buildAwsValue())
}
object DescribeChannelModeratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeChannelModeratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DescribeChannelModeratorResponse =
      zio.aws.chime.model.DescribeChannelModeratorResponse(
        channelModerator.map(value => value.asEditable)
      )
    def channelModerator
        : Optional[zio.aws.chime.model.ChannelModerator.ReadOnly]
    def getChannelModerator
        : ZIO[Any, AwsError, zio.aws.chime.model.ChannelModerator.ReadOnly] =
      AwsError.unwrapOptionField("channelModerator", channelModerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelModeratorResponse
  ) extends zio.aws.chime.model.DescribeChannelModeratorResponse.ReadOnly {
    override val channelModerator
        : Optional[zio.aws.chime.model.ChannelModerator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelModerator())
        .map(value => zio.aws.chime.model.ChannelModerator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelModeratorResponse
  ): zio.aws.chime.model.DescribeChannelModeratorResponse.ReadOnly =
    new Wrapper(impl)
}
