package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelResponse(
    channel: Optional[zio.aws.chime.model.Channel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DescribeChannelResponse = {
    import DescribeChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DescribeChannelResponse
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DescribeChannelResponse.ReadOnly =
    zio.aws.chime.model.DescribeChannelResponse.wrap(buildAwsValue())
}
object DescribeChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DescribeChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DescribeChannelResponse =
      zio.aws.chime.model
        .DescribeChannelResponse(channel.map(value => value.asEditable))
    def channel: Optional[zio.aws.chime.model.Channel.ReadOnly]
    def getChannel: ZIO[Any, AwsError, zio.aws.chime.model.Channel.ReadOnly] =
      AwsError.unwrapOptionField("channel", channel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelResponse
  ) extends zio.aws.chime.model.DescribeChannelResponse.ReadOnly {
    override val channel: Optional[zio.aws.chime.model.Channel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channel())
        .map(value => zio.aws.chime.model.Channel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DescribeChannelResponse
  ): zio.aws.chime.model.DescribeChannelResponse.ReadOnly = new Wrapper(impl)
}
