package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociatePhoneNumberFromUserRequest(
    accountId: String,
    userId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserRequest = {
    import DisassociatePhoneNumberFromUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .userId(userId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DisassociatePhoneNumberFromUserRequest.ReadOnly =
    zio.aws.chime.model.DisassociatePhoneNumberFromUserRequest
      .wrap(buildAwsValue())
}
object DisassociatePhoneNumberFromUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DisassociatePhoneNumberFromUserRequest =
      zio.aws.chime.model
        .DisassociatePhoneNumberFromUserRequest(accountId, userId)
    def accountId: String
    def userId: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getUserId: ZIO[Any, Nothing, String] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserRequest
  ) extends zio.aws.chime.model.DisassociatePhoneNumberFromUserRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val userId: String = impl.userId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DisassociatePhoneNumberFromUserRequest
  ): zio.aws.chime.model.DisassociatePhoneNumberFromUserRequest.ReadOnly =
    new Wrapper(impl)
}
