package zio.aws.chime.model
import zio.aws.chime.model.primitives.{E164PhoneNumber, NonEmptyString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(
    voiceConnectorGroupId: NonEmptyString,
    e164PhoneNumbers: Iterable[E164PhoneNumber]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest = {
    import DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
      .builder()
      .voiceConnectorGroupId(
        NonEmptyString.unwrap(voiceConnectorGroupId): java.lang.String
      )
      .e164PhoneNumbers(e164PhoneNumbers.map { item =>
        E164PhoneNumber.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.ReadOnly =
    zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
      .wrap(buildAwsValue())
}
object DisassociatePhoneNumbersFromVoiceConnectorGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest =
      zio.aws.chime.model
        .DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(
          voiceConnectorGroupId,
          e164PhoneNumbers
        )
    def voiceConnectorGroupId: NonEmptyString
    def e164PhoneNumbers: List[E164PhoneNumber]
    def getVoiceConnectorGroupId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorGroupId)
    def getE164PhoneNumbers: ZIO[Any, Nothing, List[E164PhoneNumber]] =
      ZIO.succeed(e164PhoneNumbers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
  ) extends zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.ReadOnly {
    override val voiceConnectorGroupId: NonEmptyString =
      zio.aws.chime.model.primitives
        .NonEmptyString(impl.voiceConnectorGroupId())
    override val e164PhoneNumbers: List[E164PhoneNumber] = impl
      .e164PhoneNumbers()
      .asScala
      .map { item =>
        zio.aws.chime.model.primitives.E164PhoneNumber(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
  ): zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.ReadOnly =
    new Wrapper(impl)
}
