package zio.aws.chime.model
import zio.aws.chime.model.primitives.{E164PhoneNumber, NonEmptyString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociatePhoneNumbersFromVoiceConnectorRequest(
    voiceConnectorId: NonEmptyString,
    e164PhoneNumbers: Iterable[E164PhoneNumber]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest = {
    import DisassociatePhoneNumbersFromVoiceConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .e164PhoneNumbers(e164PhoneNumbers.map { item =>
        E164PhoneNumber.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest.ReadOnly =
    zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest
      .wrap(buildAwsValue())
}
object DisassociatePhoneNumbersFromVoiceConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest =
      zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest(
        voiceConnectorId,
        e164PhoneNumbers
      )
    def voiceConnectorId: NonEmptyString
    def e164PhoneNumbers: List[E164PhoneNumber]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getE164PhoneNumbers: ZIO[Any, Nothing, List[E164PhoneNumber]] =
      ZIO.succeed(e164PhoneNumbers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest
  ) extends zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
    override val e164PhoneNumbers: List[E164PhoneNumber] = impl
      .e164PhoneNumbers()
      .asScala
      .map { item =>
        zio.aws.chime.model.primitives.E164PhoneNumber(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest
  ): zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest.ReadOnly =
    new Wrapper(impl)
}
