package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociatePhoneNumbersFromVoiceConnectorResponse(
    phoneNumberErrors: Optional[
      Iterable[zio.aws.chime.model.PhoneNumberError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse = {
    import DisassociatePhoneNumbersFromVoiceConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse
      .builder()
      .optionallyWith(
        phoneNumberErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumberErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly =
    zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse
      .wrap(buildAwsValue())
}
object DisassociatePhoneNumbersFromVoiceConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse =
      zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse(
        phoneNumberErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def phoneNumberErrors
        : Optional[List[zio.aws.chime.model.PhoneNumberError.ReadOnly]]
    def getPhoneNumberErrors: ZIO[Any, AwsError, List[
      zio.aws.chime.model.PhoneNumberError.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumberErrors", phoneNumberErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse
  ) extends zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly {
    override val phoneNumberErrors
        : Optional[List[zio.aws.chime.model.PhoneNumberError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.PhoneNumberError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse
  ): zio.aws.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse.ReadOnly =
    new Wrapper(impl)
}
