package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateSigninDelegateGroupsFromAccountRequest(
    accountId: NonEmptyString,
    groupNames: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest = {
    import DisassociateSigninDelegateGroupsFromAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .groupNames(groupNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest.ReadOnly =
    zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest
      .wrap(buildAwsValue())
}
object DisassociateSigninDelegateGroupsFromAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest =
      zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest(
        accountId,
        groupNames
      )
    def accountId: NonEmptyString
    def groupNames: List[String]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getGroupNames: ZIO[Any, Nothing, List[String]] = ZIO.succeed(groupNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest
  ) extends zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val groupNames: List[String] = impl
      .groupNames()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest
  ): zio.aws.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest.ReadOnly =
    new Wrapper(impl)
}
