package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait EmailStatus {
  def unwrap: software.amazon.awssdk.services.chime.model.EmailStatus
}
object EmailStatus {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.EmailStatus
  ): zio.aws.chime.model.EmailStatus = value match {
    case software.amazon.awssdk.services.chime.model.EmailStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.EmailStatus.NOT_SENT =>
      val r = NotSent
      r
    case software.amazon.awssdk.services.chime.model.EmailStatus.SENT =>
      val r = Sent
      r
    case software.amazon.awssdk.services.chime.model.EmailStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.EmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.EmailStatus =
      software.amazon.awssdk.services.chime.model.EmailStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NotSent extends zio.aws.chime.model.EmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.EmailStatus =
      software.amazon.awssdk.services.chime.model.EmailStatus.NOT_SENT
  }
  case object Sent extends zio.aws.chime.model.EmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.EmailStatus =
      software.amazon.awssdk.services.chime.model.EmailStatus.SENT
  }
  case object Failed extends zio.aws.chime.model.EmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.EmailStatus =
      software.amazon.awssdk.services.chime.model.EmailStatus.FAILED
  }
}
