package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EmergencyCallingConfiguration(
    dnis: Optional[
      Iterable[zio.aws.chime.model.DNISEmergencyCallingConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.EmergencyCallingConfiguration = {
    import EmergencyCallingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.EmergencyCallingConfiguration
      .builder()
      .optionallyWith(
        dnis.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dnis)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly =
    zio.aws.chime.model.EmergencyCallingConfiguration.wrap(buildAwsValue())
}
object EmergencyCallingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.EmergencyCallingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.EmergencyCallingConfiguration =
      zio.aws.chime.model.EmergencyCallingConfiguration(
        dnis.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dnis: Optional[
      List[zio.aws.chime.model.DNISEmergencyCallingConfiguration.ReadOnly]
    ]
    def getDnis: ZIO[Any, AwsError, List[
      zio.aws.chime.model.DNISEmergencyCallingConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("dnis", dnis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.EmergencyCallingConfiguration
  ) extends zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly {
    override val dnis: Optional[
      List[zio.aws.chime.model.DNISEmergencyCallingConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dnis())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.DNISEmergencyCallingConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.EmergencyCallingConfiguration
  ): zio.aws.chime.model.EmergencyCallingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
