package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EngineTranscribeMedicalSettings(
    languageCode: zio.aws.chime.model.TranscribeMedicalLanguageCode,
    specialty: zio.aws.chime.model.TranscribeMedicalSpecialty,
    `type`: zio.aws.chime.model.TranscribeMedicalType,
    vocabularyName: Optional[String] = Optional.Absent,
    region: Optional[zio.aws.chime.model.TranscribeMedicalRegion] =
      Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.chime.model.TranscribeMedicalContentIdentificationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.EngineTranscribeMedicalSettings = {
    import EngineTranscribeMedicalSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.EngineTranscribeMedicalSettings
      .builder()
      .languageCode(languageCode.unwrap)
      .specialty(specialty.unwrap)
      .`type`(`type`.unwrap)
      .optionallyWith(vocabularyName.map(value => value: java.lang.String))(
        _.vocabularyName
      )
      .optionallyWith(region.map(value => value.unwrap))(_.region)
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.EngineTranscribeMedicalSettings.ReadOnly =
    zio.aws.chime.model.EngineTranscribeMedicalSettings.wrap(buildAwsValue())
}
object EngineTranscribeMedicalSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.EngineTranscribeMedicalSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.EngineTranscribeMedicalSettings =
      zio.aws.chime.model.EngineTranscribeMedicalSettings(
        languageCode,
        specialty,
        `type`,
        vocabularyName.map(value => value),
        region.map(value => value),
        contentIdentificationType.map(value => value)
      )
    def languageCode: zio.aws.chime.model.TranscribeMedicalLanguageCode
    def specialty: zio.aws.chime.model.TranscribeMedicalSpecialty
    def `type`: zio.aws.chime.model.TranscribeMedicalType
    def vocabularyName: Optional[String]
    def region: Optional[zio.aws.chime.model.TranscribeMedicalRegion]
    def contentIdentificationType: Optional[
      zio.aws.chime.model.TranscribeMedicalContentIdentificationType
    ]
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.chime.model.TranscribeMedicalLanguageCode] =
      ZIO.succeed(languageCode)
    def getSpecialty
        : ZIO[Any, Nothing, zio.aws.chime.model.TranscribeMedicalSpecialty] =
      ZIO.succeed(specialty)
    def getType: ZIO[Any, Nothing, zio.aws.chime.model.TranscribeMedicalType] =
      ZIO.succeed(`type`)
    def getVocabularyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getRegion
        : ZIO[Any, AwsError, zio.aws.chime.model.TranscribeMedicalRegion] =
      AwsError.unwrapOptionField("region", region)
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.TranscribeMedicalContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.EngineTranscribeMedicalSettings
  ) extends zio.aws.chime.model.EngineTranscribeMedicalSettings.ReadOnly {
    override val languageCode
        : zio.aws.chime.model.TranscribeMedicalLanguageCode =
      zio.aws.chime.model.TranscribeMedicalLanguageCode
        .wrap(impl.languageCode())
    override val specialty: zio.aws.chime.model.TranscribeMedicalSpecialty =
      zio.aws.chime.model.TranscribeMedicalSpecialty.wrap(impl.specialty())
    override val `type`: zio.aws.chime.model.TranscribeMedicalType =
      zio.aws.chime.model.TranscribeMedicalType.wrap(impl.`type`())
    override val vocabularyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyName())
      .map(value => value: String)
    override val region: Optional[zio.aws.chime.model.TranscribeMedicalRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.region())
        .map(value => zio.aws.chime.model.TranscribeMedicalRegion.wrap(value))
    override val contentIdentificationType: Optional[
      zio.aws.chime.model.TranscribeMedicalContentIdentificationType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentIdentificationType())
      .map(value =>
        zio.aws.chime.model.TranscribeMedicalContentIdentificationType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.EngineTranscribeMedicalSettings
  ): zio.aws.chime.model.EngineTranscribeMedicalSettings.ReadOnly = new Wrapper(
    impl
  )
}
