package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  TranscribeLanguageModelName,
  TranscribePiiEntityTypes
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EngineTranscribeSettings(
    languageCode: zio.aws.chime.model.TranscribeLanguageCode,
    vocabularyFilterMethod: Optional[
      zio.aws.chime.model.TranscribeVocabularyFilterMethod
    ] = Optional.Absent,
    vocabularyFilterName: Optional[String] = Optional.Absent,
    vocabularyName: Optional[String] = Optional.Absent,
    region: Optional[zio.aws.chime.model.TranscribeRegion] = Optional.Absent,
    enablePartialResultsStabilization: Optional[Boolean] = Optional.Absent,
    partialResultsStability: Optional[
      zio.aws.chime.model.TranscribePartialResultsStability
    ] = Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.chime.model.TranscribeContentIdentificationType
    ] = Optional.Absent,
    contentRedactionType: Optional[
      zio.aws.chime.model.TranscribeContentRedactionType
    ] = Optional.Absent,
    piiEntityTypes: Optional[TranscribePiiEntityTypes] = Optional.Absent,
    languageModelName: Optional[TranscribeLanguageModelName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.EngineTranscribeSettings = {
    import EngineTranscribeSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.EngineTranscribeSettings
      .builder()
      .languageCode(languageCode.unwrap)
      .optionallyWith(vocabularyFilterMethod.map(value => value.unwrap))(
        _.vocabularyFilterMethod
      )
      .optionallyWith(
        vocabularyFilterName.map(value => value: java.lang.String)
      )(_.vocabularyFilterName)
      .optionallyWith(vocabularyName.map(value => value: java.lang.String))(
        _.vocabularyName
      )
      .optionallyWith(region.map(value => value.unwrap))(_.region)
      .optionallyWith(
        enablePartialResultsStabilization.map(value => value: java.lang.Boolean)
      )(_.enablePartialResultsStabilization)
      .optionallyWith(partialResultsStability.map(value => value.unwrap))(
        _.partialResultsStability
      )
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(contentRedactionType.map(value => value.unwrap))(
        _.contentRedactionType
      )
      .optionallyWith(
        piiEntityTypes.map(value =>
          TranscribePiiEntityTypes.unwrap(value): java.lang.String
        )
      )(_.piiEntityTypes)
      .optionallyWith(
        languageModelName.map(value =>
          TranscribeLanguageModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.EngineTranscribeSettings.ReadOnly =
    zio.aws.chime.model.EngineTranscribeSettings.wrap(buildAwsValue())
}
object EngineTranscribeSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.EngineTranscribeSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.EngineTranscribeSettings =
      zio.aws.chime.model.EngineTranscribeSettings(
        languageCode,
        vocabularyFilterMethod.map(value => value),
        vocabularyFilterName.map(value => value),
        vocabularyName.map(value => value),
        region.map(value => value),
        enablePartialResultsStabilization.map(value => value),
        partialResultsStability.map(value => value),
        contentIdentificationType.map(value => value),
        contentRedactionType.map(value => value),
        piiEntityTypes.map(value => value),
        languageModelName.map(value => value)
      )
    def languageCode: zio.aws.chime.model.TranscribeLanguageCode
    def vocabularyFilterMethod
        : Optional[zio.aws.chime.model.TranscribeVocabularyFilterMethod]
    def vocabularyFilterName: Optional[String]
    def vocabularyName: Optional[String]
    def region: Optional[zio.aws.chime.model.TranscribeRegion]
    def enablePartialResultsStabilization: Optional[Boolean]
    def partialResultsStability
        : Optional[zio.aws.chime.model.TranscribePartialResultsStability]
    def contentIdentificationType
        : Optional[zio.aws.chime.model.TranscribeContentIdentificationType]
    def contentRedactionType
        : Optional[zio.aws.chime.model.TranscribeContentRedactionType]
    def piiEntityTypes: Optional[TranscribePiiEntityTypes]
    def languageModelName: Optional[TranscribeLanguageModelName]
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.chime.model.TranscribeLanguageCode] =
      ZIO.succeed(languageCode)
    def getVocabularyFilterMethod: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.TranscribeVocabularyFilterMethod
    ] = AwsError.unwrapOptionField(
      "vocabularyFilterMethod",
      vocabularyFilterMethod
    )
    def getVocabularyFilterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getVocabularyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getRegion: ZIO[Any, AwsError, zio.aws.chime.model.TranscribeRegion] =
      AwsError.unwrapOptionField("region", region)
    def getEnablePartialResultsStabilization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enablePartialResultsStabilization",
        enablePartialResultsStabilization
      )
    def getPartialResultsStability: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.TranscribePartialResultsStability
    ] = AwsError.unwrapOptionField(
      "partialResultsStability",
      partialResultsStability
    )
    def getContentIdentificationType: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.TranscribeContentIdentificationType
    ] = AwsError.unwrapOptionField(
      "contentIdentificationType",
      contentIdentificationType
    )
    def getContentRedactionType: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.TranscribeContentRedactionType
    ] = AwsError.unwrapOptionField("contentRedactionType", contentRedactionType)
    def getPiiEntityTypes: ZIO[Any, AwsError, TranscribePiiEntityTypes] =
      AwsError.unwrapOptionField("piiEntityTypes", piiEntityTypes)
    def getLanguageModelName: ZIO[Any, AwsError, TranscribeLanguageModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.EngineTranscribeSettings
  ) extends zio.aws.chime.model.EngineTranscribeSettings.ReadOnly {
    override val languageCode: zio.aws.chime.model.TranscribeLanguageCode =
      zio.aws.chime.model.TranscribeLanguageCode.wrap(impl.languageCode())
    override val vocabularyFilterMethod
        : Optional[zio.aws.chime.model.TranscribeVocabularyFilterMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterMethod())
        .map(value =>
          zio.aws.chime.model.TranscribeVocabularyFilterMethod.wrap(value)
        )
    override val vocabularyFilterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyFilterName())
      .map(value => value: String)
    override val vocabularyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyName())
      .map(value => value: String)
    override val region: Optional[zio.aws.chime.model.TranscribeRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.region())
        .map(value => zio.aws.chime.model.TranscribeRegion.wrap(value))
    override val enablePartialResultsStabilization: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePartialResultsStabilization())
        .map(value => value: Boolean)
    override val partialResultsStability
        : Optional[zio.aws.chime.model.TranscribePartialResultsStability] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partialResultsStability())
        .map(value =>
          zio.aws.chime.model.TranscribePartialResultsStability.wrap(value)
        )
    override val contentIdentificationType
        : Optional[zio.aws.chime.model.TranscribeContentIdentificationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentIdentificationType())
        .map(value =>
          zio.aws.chime.model.TranscribeContentIdentificationType.wrap(value)
        )
    override val contentRedactionType
        : Optional[zio.aws.chime.model.TranscribeContentRedactionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRedactionType())
        .map(value =>
          zio.aws.chime.model.TranscribeContentRedactionType.wrap(value)
        )
    override val piiEntityTypes: Optional[TranscribePiiEntityTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.piiEntityTypes())
        .map(value =>
          zio.aws.chime.model.primitives.TranscribePiiEntityTypes(value)
        )
    override val languageModelName: Optional[TranscribeLanguageModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageModelName())
        .map(value =>
          zio.aws.chime.model.primitives.TranscribeLanguageModelName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.EngineTranscribeSettings
  ): zio.aws.chime.model.EngineTranscribeSettings.ReadOnly = new Wrapper(impl)
}
