package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.ErrorCode
  ): zio.aws.chime.model.ErrorCode = value match {
    case software.amazon.awssdk.services.chime.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.BAD_REQUEST =>
      val r = BadRequest
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.CONFLICT =>
      val r = Conflict
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.FORBIDDEN =>
      val r = Forbidden
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.NOT_FOUND =>
      val r = NotFound
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.PRECONDITION_FAILED =>
      val r = PreconditionFailed
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.RESOURCE_LIMIT_EXCEEDED =>
      val r = ResourceLimitExceeded
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.SERVICE_FAILURE =>
      val r = ServiceFailure
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.SERVICE_UNAVAILABLE =>
      val r = ServiceUnavailable
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.THROTTLED =>
      val r = Throttled
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.THROTTLING =>
      val r = Throttling
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.UNAUTHORIZED =>
      val r = Unauthorized
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.UNPROCESSABLE =>
      val r = Unprocessable
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.VOICE_CONNECTOR_GROUP_ASSOCIATIONS_EXIST =>
      val r = VoiceConnectorGroupAssociationsExist
      r
    case software.amazon.awssdk.services.chime.model.ErrorCode.PHONE_NUMBER_ASSOCIATIONS_EXIST =>
      val r = PhoneNumberAssociationsExist
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object BadRequest extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.BAD_REQUEST
  }
  case object Conflict extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.CONFLICT
  }
  case object Forbidden extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.FORBIDDEN
  }
  case object NotFound extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.NOT_FOUND
  }
  case object PreconditionFailed extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.PRECONDITION_FAILED
  }
  case object ResourceLimitExceeded extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.RESOURCE_LIMIT_EXCEEDED
  }
  case object ServiceFailure extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.SERVICE_FAILURE
  }
  case object AccessDenied extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.ACCESS_DENIED
  }
  case object ServiceUnavailable extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.SERVICE_UNAVAILABLE
  }
  case object Throttled extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.THROTTLED
  }
  case object Throttling extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.THROTTLING
  }
  case object Unauthorized extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.UNAUTHORIZED
  }
  case object Unprocessable extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.UNPROCESSABLE
  }
  case object VoiceConnectorGroupAssociationsExist
      extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.VOICE_CONNECTOR_GROUP_ASSOCIATIONS_EXIST
  }
  case object PhoneNumberAssociationsExist
      extends zio.aws.chime.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.chime.model.ErrorCode =
      software.amazon.awssdk.services.chime.model.ErrorCode.PHONE_NUMBER_ASSOCIATIONS_EXIST
  }
}
