package zio.aws.chime.model
import zio.aws.chime.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventsConfiguration(
    botId: Optional[String] = Optional.Absent,
    outboundEventsHTTPSEndpoint: Optional[SensitiveString] = Optional.Absent,
    lambdaFunctionArn: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.EventsConfiguration = {
    import EventsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.EventsConfiguration
      .builder()
      .optionallyWith(botId.map(value => value: java.lang.String))(_.botId)
      .optionallyWith(
        outboundEventsHTTPSEndpoint.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.outboundEventsHTTPSEndpoint)
      .optionallyWith(
        lambdaFunctionArn.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.lambdaFunctionArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.EventsConfiguration.ReadOnly =
    zio.aws.chime.model.EventsConfiguration.wrap(buildAwsValue())
}
object EventsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.EventsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.EventsConfiguration =
      zio.aws.chime.model.EventsConfiguration(
        botId.map(value => value),
        outboundEventsHTTPSEndpoint.map(value => value),
        lambdaFunctionArn.map(value => value)
      )
    def botId: Optional[String]
    def outboundEventsHTTPSEndpoint: Optional[SensitiveString]
    def lambdaFunctionArn: Optional[SensitiveString]
    def getBotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("botId", botId)
    def getOutboundEventsHTTPSEndpoint: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField(
        "outboundEventsHTTPSEndpoint",
        outboundEventsHTTPSEndpoint
      )
    def getLambdaFunctionArn: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("lambdaFunctionArn", lambdaFunctionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.EventsConfiguration
  ) extends zio.aws.chime.model.EventsConfiguration.ReadOnly {
    override val botId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => value: String)
    override val outboundEventsHTTPSEndpoint: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outboundEventsHTTPSEndpoint())
        .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
    override val lambdaFunctionArn: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaFunctionArn())
        .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.EventsConfiguration
  ): zio.aws.chime.model.EventsConfiguration.ReadOnly = new Wrapper(impl)
}
