package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAccountRequest(accountId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetAccountRequest = {
    import GetAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetAccountRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetAccountRequest.ReadOnly =
    zio.aws.chime.model.GetAccountRequest.wrap(buildAwsValue())
}
object GetAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetAccountRequest =
      zio.aws.chime.model.GetAccountRequest(accountId)
    def accountId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetAccountRequest
  ) extends zio.aws.chime.model.GetAccountRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetAccountRequest
  ): zio.aws.chime.model.GetAccountRequest.ReadOnly = new Wrapper(impl)
}
