package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAccountResponse(
    account: Optional[zio.aws.chime.model.Account] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetAccountResponse = {
    import GetAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetAccountResponse
      .builder()
      .optionallyWith(account.map(value => value.buildAwsValue()))(_.account)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetAccountResponse.ReadOnly =
    zio.aws.chime.model.GetAccountResponse.wrap(buildAwsValue())
}
object GetAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetAccountResponse = zio.aws.chime.model
      .GetAccountResponse(account.map(value => value.asEditable))
    def account: Optional[zio.aws.chime.model.Account.ReadOnly]
    def getAccount: ZIO[Any, AwsError, zio.aws.chime.model.Account.ReadOnly] =
      AwsError.unwrapOptionField("account", account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetAccountResponse
  ) extends zio.aws.chime.model.GetAccountResponse.ReadOnly {
    override val account: Optional[zio.aws.chime.model.Account.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.account())
        .map(value => zio.aws.chime.model.Account.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetAccountResponse
  ): zio.aws.chime.model.GetAccountResponse.ReadOnly = new Wrapper(impl)
}
