package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAccountSettingsRequest(accountId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetAccountSettingsRequest = {
    import GetAccountSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetAccountSettingsRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetAccountSettingsRequest.ReadOnly =
    zio.aws.chime.model.GetAccountSettingsRequest.wrap(buildAwsValue())
}
object GetAccountSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetAccountSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetAccountSettingsRequest =
      zio.aws.chime.model.GetAccountSettingsRequest(accountId)
    def accountId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetAccountSettingsRequest
  ) extends zio.aws.chime.model.GetAccountSettingsRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetAccountSettingsRequest
  ): zio.aws.chime.model.GetAccountSettingsRequest.ReadOnly = new Wrapper(impl)
}
