package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAccountSettingsResponse(
    accountSettings: Optional[zio.aws.chime.model.AccountSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetAccountSettingsResponse = {
    import GetAccountSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetAccountSettingsResponse
      .builder()
      .optionallyWith(accountSettings.map(value => value.buildAwsValue()))(
        _.accountSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetAccountSettingsResponse.ReadOnly =
    zio.aws.chime.model.GetAccountSettingsResponse.wrap(buildAwsValue())
}
object GetAccountSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetAccountSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetAccountSettingsResponse =
      zio.aws.chime.model.GetAccountSettingsResponse(
        accountSettings.map(value => value.asEditable)
      )
    def accountSettings: Optional[zio.aws.chime.model.AccountSettings.ReadOnly]
    def getAccountSettings
        : ZIO[Any, AwsError, zio.aws.chime.model.AccountSettings.ReadOnly] =
      AwsError.unwrapOptionField("accountSettings", accountSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetAccountSettingsResponse
  ) extends zio.aws.chime.model.GetAccountSettingsResponse.ReadOnly {
    override val accountSettings
        : Optional[zio.aws.chime.model.AccountSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountSettings())
        .map(value => zio.aws.chime.model.AccountSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetAccountSettingsResponse
  ): zio.aws.chime.model.GetAccountSettingsResponse.ReadOnly = new Wrapper(impl)
}
