package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAppInstanceRetentionSettingsRequest(
    appInstanceArn: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetAppInstanceRetentionSettingsRequest = {
    import GetAppInstanceRetentionSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetAppInstanceRetentionSettingsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetAppInstanceRetentionSettingsRequest.ReadOnly =
    zio.aws.chime.model.GetAppInstanceRetentionSettingsRequest
      .wrap(buildAwsValue())
}
object GetAppInstanceRetentionSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetAppInstanceRetentionSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetAppInstanceRetentionSettingsRequest =
      zio.aws.chime.model.GetAppInstanceRetentionSettingsRequest(appInstanceArn)
    def appInstanceArn: ChimeArn
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetAppInstanceRetentionSettingsRequest
  ) extends zio.aws.chime.model.GetAppInstanceRetentionSettingsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetAppInstanceRetentionSettingsRequest
  ): zio.aws.chime.model.GetAppInstanceRetentionSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
