package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAppInstanceStreamingConfigurationsRequest(
    appInstanceArn: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetAppInstanceStreamingConfigurationsRequest = {
    import GetAppInstanceStreamingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetAppInstanceStreamingConfigurationsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.GetAppInstanceStreamingConfigurationsRequest.ReadOnly =
    zio.aws.chime.model.GetAppInstanceStreamingConfigurationsRequest
      .wrap(buildAwsValue())
}
object GetAppInstanceStreamingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetAppInstanceStreamingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.GetAppInstanceStreamingConfigurationsRequest =
      zio.aws.chime.model
        .GetAppInstanceStreamingConfigurationsRequest(appInstanceArn)
    def appInstanceArn: ChimeArn
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetAppInstanceStreamingConfigurationsRequest
  ) extends zio.aws.chime.model.GetAppInstanceStreamingConfigurationsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetAppInstanceStreamingConfigurationsRequest
  ): zio.aws.chime.model.GetAppInstanceStreamingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
