package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAttendeeRequest(
    meetingId: GuidString,
    attendeeId: GuidString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetAttendeeRequest = {
    import GetAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .attendeeId(GuidString.unwrap(attendeeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetAttendeeRequest.ReadOnly =
    zio.aws.chime.model.GetAttendeeRequest.wrap(buildAwsValue())
}
object GetAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetAttendeeRequest =
      zio.aws.chime.model.GetAttendeeRequest(meetingId, attendeeId)
    def meetingId: GuidString
    def attendeeId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getAttendeeId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(attendeeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetAttendeeRequest
  ) extends zio.aws.chime.model.GetAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val attendeeId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.attendeeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetAttendeeRequest
  ): zio.aws.chime.model.GetAttendeeRequest.ReadOnly = new Wrapper(impl)
}
