package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAttendeeResponse(
    attendee: Optional[zio.aws.chime.model.Attendee] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetAttendeeResponse = {
    import GetAttendeeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetAttendeeResponse
      .builder()
      .optionallyWith(attendee.map(value => value.buildAwsValue()))(_.attendee)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetAttendeeResponse.ReadOnly =
    zio.aws.chime.model.GetAttendeeResponse.wrap(buildAwsValue())
}
object GetAttendeeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetAttendeeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetAttendeeResponse =
      zio.aws.chime.model
        .GetAttendeeResponse(attendee.map(value => value.asEditable))
    def attendee: Optional[zio.aws.chime.model.Attendee.ReadOnly]
    def getAttendee: ZIO[Any, AwsError, zio.aws.chime.model.Attendee.ReadOnly] =
      AwsError.unwrapOptionField("attendee", attendee)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetAttendeeResponse
  ) extends zio.aws.chime.model.GetAttendeeResponse.ReadOnly {
    override val attendee: Optional[zio.aws.chime.model.Attendee.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attendee())
        .map(value => zio.aws.chime.model.Attendee.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetAttendeeResponse
  ): zio.aws.chime.model.GetAttendeeResponse.ReadOnly = new Wrapper(impl)
}
