package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetBotRequest(
    accountId: NonEmptyString,
    botId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetBotRequest = {
    import GetBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetBotRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .botId(NonEmptyString.unwrap(botId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetBotRequest.ReadOnly =
    zio.aws.chime.model.GetBotRequest.wrap(buildAwsValue())
}
object GetBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetBotRequest =
      zio.aws.chime.model.GetBotRequest(accountId, botId)
    def accountId: NonEmptyString
    def botId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getBotId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(botId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetBotRequest
  ) extends zio.aws.chime.model.GetBotRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val botId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.botId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetBotRequest
  ): zio.aws.chime.model.GetBotRequest.ReadOnly = new Wrapper(impl)
}
