package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetChannelMessageResponse(
    channelMessage: Optional[zio.aws.chime.model.ChannelMessage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetChannelMessageResponse = {
    import GetChannelMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetChannelMessageResponse
      .builder()
      .optionallyWith(channelMessage.map(value => value.buildAwsValue()))(
        _.channelMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetChannelMessageResponse.ReadOnly =
    zio.aws.chime.model.GetChannelMessageResponse.wrap(buildAwsValue())
}
object GetChannelMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetChannelMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetChannelMessageResponse =
      zio.aws.chime.model.GetChannelMessageResponse(
        channelMessage.map(value => value.asEditable)
      )
    def channelMessage: Optional[zio.aws.chime.model.ChannelMessage.ReadOnly]
    def getChannelMessage
        : ZIO[Any, AwsError, zio.aws.chime.model.ChannelMessage.ReadOnly] =
      AwsError.unwrapOptionField("channelMessage", channelMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetChannelMessageResponse
  ) extends zio.aws.chime.model.GetChannelMessageResponse.ReadOnly {
    override val channelMessage
        : Optional[zio.aws.chime.model.ChannelMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelMessage())
        .map(value => zio.aws.chime.model.ChannelMessage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetChannelMessageResponse
  ): zio.aws.chime.model.GetChannelMessageResponse.ReadOnly = new Wrapper(impl)
}
