package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGlobalSettingsResponse(
    businessCalling: Optional[zio.aws.chime.model.BusinessCallingSettings] =
      Optional.Absent,
    voiceConnector: Optional[zio.aws.chime.model.VoiceConnectorSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetGlobalSettingsResponse = {
    import GetGlobalSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetGlobalSettingsResponse
      .builder()
      .optionallyWith(businessCalling.map(value => value.buildAwsValue()))(
        _.businessCalling
      )
      .optionallyWith(voiceConnector.map(value => value.buildAwsValue()))(
        _.voiceConnector
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetGlobalSettingsResponse.ReadOnly =
    zio.aws.chime.model.GetGlobalSettingsResponse.wrap(buildAwsValue())
}
object GetGlobalSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetGlobalSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetGlobalSettingsResponse =
      zio.aws.chime.model.GetGlobalSettingsResponse(
        businessCalling.map(value => value.asEditable),
        voiceConnector.map(value => value.asEditable)
      )
    def businessCalling
        : Optional[zio.aws.chime.model.BusinessCallingSettings.ReadOnly]
    def voiceConnector
        : Optional[zio.aws.chime.model.VoiceConnectorSettings.ReadOnly]
    def getBusinessCalling: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.BusinessCallingSettings.ReadOnly
    ] = AwsError.unwrapOptionField("businessCalling", businessCalling)
    def getVoiceConnector: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.VoiceConnectorSettings.ReadOnly
    ] = AwsError.unwrapOptionField("voiceConnector", voiceConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetGlobalSettingsResponse
  ) extends zio.aws.chime.model.GetGlobalSettingsResponse.ReadOnly {
    override val businessCalling
        : Optional[zio.aws.chime.model.BusinessCallingSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.businessCalling())
        .map(value => zio.aws.chime.model.BusinessCallingSettings.wrap(value))
    override val voiceConnector
        : Optional[zio.aws.chime.model.VoiceConnectorSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnector())
        .map(value => zio.aws.chime.model.VoiceConnectorSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetGlobalSettingsResponse
  ): zio.aws.chime.model.GetGlobalSettingsResponse.ReadOnly = new Wrapper(impl)
}
