package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMediaCapturePipelineRequest(mediaPipelineId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineRequest = {
    import GetMediaCapturePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineRequest
      .builder()
      .mediaPipelineId(GuidString.unwrap(mediaPipelineId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetMediaCapturePipelineRequest.ReadOnly =
    zio.aws.chime.model.GetMediaCapturePipelineRequest.wrap(buildAwsValue())
}
object GetMediaCapturePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetMediaCapturePipelineRequest =
      zio.aws.chime.model.GetMediaCapturePipelineRequest(mediaPipelineId)
    def mediaPipelineId: GuidString
    def getMediaPipelineId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(mediaPipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineRequest
  ) extends zio.aws.chime.model.GetMediaCapturePipelineRequest.ReadOnly {
    override val mediaPipelineId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.mediaPipelineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineRequest
  ): zio.aws.chime.model.GetMediaCapturePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
