package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMediaCapturePipelineResponse(
    mediaCapturePipeline: Optional[zio.aws.chime.model.MediaCapturePipeline] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineResponse = {
    import GetMediaCapturePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineResponse
      .builder()
      .optionallyWith(mediaCapturePipeline.map(value => value.buildAwsValue()))(
        _.mediaCapturePipeline
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetMediaCapturePipelineResponse.ReadOnly =
    zio.aws.chime.model.GetMediaCapturePipelineResponse.wrap(buildAwsValue())
}
object GetMediaCapturePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetMediaCapturePipelineResponse =
      zio.aws.chime.model.GetMediaCapturePipelineResponse(
        mediaCapturePipeline.map(value => value.asEditable)
      )
    def mediaCapturePipeline
        : Optional[zio.aws.chime.model.MediaCapturePipeline.ReadOnly]
    def getMediaCapturePipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.MediaCapturePipeline.ReadOnly
    ] = AwsError.unwrapOptionField("mediaCapturePipeline", mediaCapturePipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineResponse
  ) extends zio.aws.chime.model.GetMediaCapturePipelineResponse.ReadOnly {
    override val mediaCapturePipeline
        : Optional[zio.aws.chime.model.MediaCapturePipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaCapturePipeline())
        .map(value => zio.aws.chime.model.MediaCapturePipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetMediaCapturePipelineResponse
  ): zio.aws.chime.model.GetMediaCapturePipelineResponse.ReadOnly = new Wrapper(
    impl
  )
}
