package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMeetingRequest(meetingId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetMeetingRequest = {
    import GetMeetingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetMeetingRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetMeetingRequest.ReadOnly =
    zio.aws.chime.model.GetMeetingRequest.wrap(buildAwsValue())
}
object GetMeetingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetMeetingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetMeetingRequest =
      zio.aws.chime.model.GetMeetingRequest(meetingId)
    def meetingId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetMeetingRequest
  ) extends zio.aws.chime.model.GetMeetingRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetMeetingRequest
  ): zio.aws.chime.model.GetMeetingRequest.ReadOnly = new Wrapper(impl)
}
