package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMeetingResponse(
    meeting: Optional[zio.aws.chime.model.Meeting] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetMeetingResponse = {
    import GetMeetingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetMeetingResponse
      .builder()
      .optionallyWith(meeting.map(value => value.buildAwsValue()))(_.meeting)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetMeetingResponse.ReadOnly =
    zio.aws.chime.model.GetMeetingResponse.wrap(buildAwsValue())
}
object GetMeetingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetMeetingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetMeetingResponse = zio.aws.chime.model
      .GetMeetingResponse(meeting.map(value => value.asEditable))
    def meeting: Optional[zio.aws.chime.model.Meeting.ReadOnly]
    def getMeeting: ZIO[Any, AwsError, zio.aws.chime.model.Meeting.ReadOnly] =
      AwsError.unwrapOptionField("meeting", meeting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetMeetingResponse
  ) extends zio.aws.chime.model.GetMeetingResponse.ReadOnly {
    override val meeting: Optional[zio.aws.chime.model.Meeting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.meeting())
        .map(value => zio.aws.chime.model.Meeting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetMeetingResponse
  ): zio.aws.chime.model.GetMeetingResponse.ReadOnly = new Wrapper(impl)
}
