package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPhoneNumberOrderRequest(phoneNumberOrderId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderRequest = {
    import GetPhoneNumberOrderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderRequest
      .builder()
      .phoneNumberOrderId(
        GuidString.unwrap(phoneNumberOrderId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetPhoneNumberOrderRequest.ReadOnly =
    zio.aws.chime.model.GetPhoneNumberOrderRequest.wrap(buildAwsValue())
}
object GetPhoneNumberOrderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetPhoneNumberOrderRequest =
      zio.aws.chime.model.GetPhoneNumberOrderRequest(phoneNumberOrderId)
    def phoneNumberOrderId: GuidString
    def getPhoneNumberOrderId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(phoneNumberOrderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderRequest
  ) extends zio.aws.chime.model.GetPhoneNumberOrderRequest.ReadOnly {
    override val phoneNumberOrderId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.phoneNumberOrderId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderRequest
  ): zio.aws.chime.model.GetPhoneNumberOrderRequest.ReadOnly = new Wrapper(impl)
}
