package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPhoneNumberOrderResponse(
    phoneNumberOrder: Optional[zio.aws.chime.model.PhoneNumberOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderResponse = {
    import GetPhoneNumberOrderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderResponse
      .builder()
      .optionallyWith(phoneNumberOrder.map(value => value.buildAwsValue()))(
        _.phoneNumberOrder
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetPhoneNumberOrderResponse.ReadOnly =
    zio.aws.chime.model.GetPhoneNumberOrderResponse.wrap(buildAwsValue())
}
object GetPhoneNumberOrderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetPhoneNumberOrderResponse =
      zio.aws.chime.model.GetPhoneNumberOrderResponse(
        phoneNumberOrder.map(value => value.asEditable)
      )
    def phoneNumberOrder
        : Optional[zio.aws.chime.model.PhoneNumberOrder.ReadOnly]
    def getPhoneNumberOrder
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberOrder.ReadOnly] =
      AwsError.unwrapOptionField("phoneNumberOrder", phoneNumberOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderResponse
  ) extends zio.aws.chime.model.GetPhoneNumberOrderResponse.ReadOnly {
    override val phoneNumberOrder
        : Optional[zio.aws.chime.model.PhoneNumberOrder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberOrder())
        .map(value => zio.aws.chime.model.PhoneNumberOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetPhoneNumberOrderResponse
  ): zio.aws.chime.model.GetPhoneNumberOrderResponse.ReadOnly = new Wrapper(
    impl
  )
}
