package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPhoneNumberRequest(phoneNumberId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.GetPhoneNumberRequest = {
    import GetPhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.GetPhoneNumberRequest
      .builder()
      .phoneNumberId(phoneNumberId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.GetPhoneNumberRequest.ReadOnly =
    zio.aws.chime.model.GetPhoneNumberRequest.wrap(buildAwsValue())
}
object GetPhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.GetPhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.GetPhoneNumberRequest =
      zio.aws.chime.model.GetPhoneNumberRequest(phoneNumberId)
    def phoneNumberId: String
    def getPhoneNumberId: ZIO[Any, Nothing, String] = ZIO.succeed(phoneNumberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.GetPhoneNumberRequest
  ) extends zio.aws.chime.model.GetPhoneNumberRequest.ReadOnly {
    override val phoneNumberId: String = impl.phoneNumberId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.GetPhoneNumberRequest
  ): zio.aws.chime.model.GetPhoneNumberRequest.ReadOnly = new Wrapper(impl)
}
